/*
 * Decompiled with CFR 0.152.
 */
import javax.swing.SwingUtilities;

public abstract class AbstractMessageHandler
implements GlobalConstants {
    boolean errorHandledByEventThread;
    boolean messageHandledByEventThread;

    public AbstractMessageHandler(boolean messageHandledByEventThread, boolean errorHandledByEventThread) {
        this.messageHandledByEventThread = messageHandledByEventThread;
        this.errorHandledByEventThread = errorHandledByEventThread;
    }

    public AbstractMessageHandler() {
        this.messageHandledByEventThread = false;
        this.errorHandledByEventThread = false;
    }

    public void dispatchErrorHandler(Message message) {
        if (this.messageHandledByEventThread) {
            SwingUtilities.invokeLater(new ErrorHandler(message));
        } else {
            this.handleError(message);
        }
    }

    public void dispatchMessageHandler(Message message) {
        if (this.messageHandledByEventThread) {
            SwingUtilities.invokeLater(new MessageHandler(message));
        } else {
            this.handleMessage(message);
        }
    }

    protected void handleError(Message message) {
    }

    protected abstract void handleMessage(Message var1);

    private class ErrorHandler
    implements Runnable {
        Message message;

        public ErrorHandler(Message message) {
            this.message = message;
        }

        public void run() {
            AbstractMessageHandler.this.handleError(this.message);
        }
    }

    private class MessageHandler
    implements Runnable {
        Message message;

        public MessageHandler(Message message) {
            this.message = message;
        }

        public void run() {
            AbstractMessageHandler.this.handleMessage(this.message);
        }
    }
}

