/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileOutputStream;
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public abstract class AbstractDatabase
implements GlobalConstants {
    protected CommManager commManager;
    protected AbstractMessageHandler countsMessageHandler;
    protected DatabaseManager databaseManager;
    protected AbstractMessageHandler infoMessageHandler;
    protected boolean initializing;
    protected ArrayList notifyList;
    protected int previousState;
    protected boolean slowInitMode;
    protected int state;
    protected long updateCount;
    protected String updateCountType;
    protected boolean valid;

    public AbstractDatabase(DatabaseManager databaseManager, String updateCountType) {
        this.databaseManager = databaseManager;
        this.commManager = databaseManager.commManager;
        this.updateCountType = updateCountType;
        this.notifyList = new ArrayList();
        this.infoMessageHandler = new AbstractMessageHandler(){

            public void handleMessage(Message message) {
                AbstractDatabase.this.processNewData(message);
            }
        };
        this.countsMessageHandler = new AbstractMessageHandler(){

            public void handleMessage(Message message) {
                AbstractDatabase.this.processUpdateCountsMessage(message);
            }
        };
    }

    public synchronized void addUpdateListener(Runnable updateListener) {
        this.notifyList.add(updateListener);
    }

    protected void getFirst() {
        String request = "<si:Request><si:Type>" + this.updateCountType + "Info</si:Type>" + "<si:Qualifier>First</si:Qualifier>" + "</si:Request>";
        this.commManager.sendMessage("Get", request, this.infoMessageHandler);
    }

    protected void getNew() {
        String request = "<si:Request><si:Type>" + this.updateCountType + "Info</si:Type>" + "<si:Qualifier>New</si:Qualifier>" + "</si:Request>";
        this.commManager.sendMessage("Get", request, this.infoMessageHandler);
    }

    protected void getNext(long count) {
        String request = "<si:Request><si:Type>" + this.updateCountType + "Info</si:Type>" + "<si:Qualifier>Next</si:Qualifier>" + "<si:" + this.updateCountType + ">" + count + "</si:" + this.updateCountType + ">" + "</si:Request>";
        this.databaseManager.commManager.sendMessage("Get", request, this.infoMessageHandler);
    }

    protected void getNext(int count) {
        this.getNext((long)count);
    }

    protected void getThis(String count) {
        String request = "<si:Request><si:Type>" + this.updateCountType + "Info</si:Type>" + "<si:Qualifier>This</si:Qualifier>" + "<si:" + this.updateCountType + ">" + count + "</si:" + this.updateCountType + ">" + "</si:Request>";
        this.databaseManager.commManager.sendMessage("Get", request, this.infoMessageHandler);
    }

    protected void getThis(long count) {
        String request = "<si:Request><si:Type>" + this.updateCountType + "Info</si:Type>" + "<si:Qualifier>This</si:Qualifier>" + "<si:" + this.updateCountType + ">" + count + "</si:" + this.updateCountType + ">" + "</si:Request>";
        this.databaseManager.commManager.sendMessage("Get", request, this.infoMessageHandler);
    }

    protected void getThis(int count) {
        String request = "<si:Request><si:Type>" + this.updateCountType + "Info</si:Type>" + "<si:Qualifier>This</si:Qualifier>" + "<si:" + this.updateCountType + ">" + count + "</si:" + this.updateCountType + ">" + "</si:Request>";
        this.databaseManager.commManager.sendMessage("Get", request, this.infoMessageHandler);
    }

    public void initializationComplete() {
        this.valid = true;
        this.initializing = false;
        ApplicationLog.put(this.getClass().getName() + " initialization completed");
        System.out.print(this.getClass().getName() + " initialization completed\n");
        this.databaseManager.initializationComplete(this.getClass().getName());
        this.notifyListeners();
    }

    public synchronized void initialize() {
        this.initializing = true;
        ApplicationLog.put(this.getClass().getName() + " initialization started");
        System.out.println(this.getClass().getName() + " initialization started");
    }

    public synchronized void loadSnapshot(XmlData xmlData) {
    }

    public void notifyListeners() {
        int index = 0;
        while (index < this.notifyList.size()) {
            SwingUtilities.invokeLater((Runnable)this.notifyList.get(index));
            ++index;
        }
    }

    public synchronized void nuke() {
        this.valid = false;
        this.initializing = false;
        ApplicationLog.put(this.getClass().getName() + " nuked");
        System.out.print(this.getClass().getName() + " nuked\n");
        this.notifyListeners();
    }

    protected abstract void processNewData(Message var1);

    public void processUpdateCount(long latestUpdateCount) {
        if (latestUpdateCount != this.updateCount) {
            String request = "<si:Request><si:Type>" + this.updateCountType + "UpdateCounts</si:Type>" + "</si:Request>";
            this.databaseManager.commManager.sendMessage("Get", request, this.countsMessageHandler);
            this.updateCount = latestUpdateCount;
        }
    }

    protected void processUpdateCountsMessage(Message message) {
    }

    public synchronized void removeUpdateListener(Runnable updateListener) {
        int index = 0;
        while (index < this.notifyList.size()) {
            if ((Runnable)this.notifyList.get(index) == updateListener) {
                this.notifyList.remove(index);
                break;
            }
            ++index;
        }
    }

    public void resume() {
        if (this.state == 2) {
            this.state = this.previousState;
            ApplicationLog.put(this.getClass().getName() + " resumed");
            System.out.print(this.getClass().getName() + " resumed\n");
            this.notifyListeners();
        }
    }

    public synchronized void saveSnapshot(FileOutputStream outputStream) {
    }

    public void setInitialUpdateCount(long initialUpdateCount) {
        this.updateCount = initialUpdateCount;
    }

    public void suspend() {
        if (this.state != 2) {
            this.previousState = this.state;
            this.state = 2;
            ApplicationLog.put(this.getClass().getName() + " suspended");
            System.out.print(this.getClass().getName() + " suspended\n");
            this.notifyListeners();
        }
    }

    public boolean valid() {
        return this.valid;
    }
}

