/* space.c */

#include "config.h"

#ifdef P9264_CNTLS
#define MAX_ADAPTERS (P9264_CNTLS+P9263_CNTLS+P9262_CNTLS+P9261_CNTLS+P926_CNTLS) 

#elif P9263_CNTLS
#define MAX_ADAPTERS (P9263_CNTLS+P9262_CNTLS+P9261_CNTLS+P926_CNTLS) 

#elif P9262_CNTLS
#define MAX_ADAPTERS (P9262_CNTLS+P9261_CNTLS+P926_CNTLS) 

#elif P9261_CNTLS
#define MAX_ADAPTERS (P9261_CNTLS+P926_CNTLS) 

#else
#define MAX_ADAPTERS (P926_CNTLS) 
#endif

int p926_num_dev = MAX_ADAPTERS;

char *Pciid1="0";
char *Pciid2="0";
char *Pciid3="0";
char *Pciid4="0";

typedef	struct {
	int  start_addr; /* RAM starting address	*/
	int  end_addr;	 /* RAM ending address	*/
	int  IRQ;	 /* Interrupt 		*/
	int  PORT;	 /* I/O address		*/
} T_p926_sdev;

T_p926_sdev	Sdev[MAX_ADAPTERS] = {
#ifdef P926_0
	{
		P926_0_SCMA, 	/* RAM starting address */
		P926_0_ECMA,	/* RAM ending address	*/
		P926_0_VECT,	/* IRQ			*/
		P926_0_SIOA		/* I/O address		*/
	}
#endif
#ifdef P9261_0
	,
	{
		P926_0_SCMA, 	/* RAM starting address */
		P9261_0_ECMA,	/* RAM ending address	*/
		P9261_0_VECT,	/* IRQ			*/
		P9261_0_SIOA	/* I/O address		*/
	}
#endif
#ifdef P9262_0
	,
	{
		P926_0_SCMA, 	/* RAM starting address */
		P9262_0_ECMA,	/* RAM ending address	*/
		P9262_0_VECT,	/* IRQ			*/
		P9262_0_SIOA	/* I/O address		*/
	}
#endif
#ifdef P9263_0
	,
	{
		P926_0_SCMA, 	/* RAM starting address */
		P9263_0_ECMA,	/* RAM ending address	*/
		P9263_0_VECT,	/* IRQ			*/
		P9263_0_SIOA	/* I/O address		*/
	}
#endif
#ifdef P9264_0
	,
	{
		P926_0_SCMA, 	/* RAM starting address */
		P9264_0_ECMA,	/* RAM ending address	*/
		P9264_0_VECT,	/* IRQ			*/
		P9264_0_SIOA	/* I/O address		*/
	}
#endif
};
