//  1394CameraControlSize.h: interface for the C1394CameraControlSize class.
//
//	Version 5.2
//
//	Copyright 5/2000
// 
//	Iwan Ulrich
//	Robotics Institute
//	Carnegie Mellon University
//	Pittsburgh, PA
//
//  Copyright 3/2002
//
//  Christopher Baker
//  Robotics Institute
//  Carnegie Mellon University
//  Pittsburgh, PA
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//  
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//////////////////////////////////////////////////////////////////////

#ifndef __1394CAMERACONTROLSIZE_H__
#define __1394CAMERACONTROLSIZE_H__

#include "1394CameraControl.h"

class C1394Camera;

class CAMAPI C1394CameraControlSize  
{
friend C1394Camera;

public:
	bool Supported();
	bool ModeSupported(int mode);
	int SetColorCode(int code);
	int SetSize(int width, int height);
	int SetPosition(int left, int top);
	int Status();
	C1394CameraControlSize();
	virtual ~C1394CameraControlSize();

	int m_maxH;
	int m_maxV;
	int m_unitH;
	int m_unitV;
	int m_top;
	int m_left;
	int m_width;
	int m_height;
	int m_colorCode;
	bool m_colorCodes[7];

	C1394Camera* m_pCamera;

private:
	int SetBytesPerPacket(int bytes);
	int Update();
	unsigned long m_pixelsFrame;
	unsigned long m_bytesFrameHigh;
	unsigned long m_bytesFrameLow;
	unsigned long m_bytesPacketMin;
	unsigned long m_bytesPacketMax;
	unsigned long m_bytesPacket;
	unsigned long m_offset;
};

#endif // __1394CAMERACONTROLSIZE_H__
