
{===========================================================================}
{ Konzept        : DATA BECKERs Sound Blaster Superbuch                     }
{ Prog. SBInfo   : Ein kleines Beispielprogramm fr die Unit SBDrv, welches }
{                  Informationen ber den Typ der Sound-Blaster-Karte,      }
{                  Treiberpfad, Basis-I/O-Adresse, Interrupt-Nummer, DMA-   }
{                  Kanal und Version des CT-VOICE-Treibers auf dem Bild-    }
{                  schirm anzeigt.                                          }
{===========================================================================}
{ Autor          : Arthur Burda                                             }
{ Dateiname      : SBINFO.PAS                                               }
{ entwickelt am  : 10.05.1993                                               }
{ letztes Update : 01.09.1993                                               }
{ Version        : 1.04                                                     }
{ Compiler       : Turbo Pascal 6.0 und hher                               }
{===========================================================================}

PROGRAM SBInfo;

{---------------------------------------------------------------------------}
{ Compiler-Schalter                                                         }
{---------------------------------------------------------------------------}

{$D-}                                        { keine Debugger-Informationen }
{$F-}                                        { FAR-Aufrufe sind nicht ntig }
{$G+}                                                   { 286-Code erzeugen }
{$I-}                                                   { keine I/O-Prfung }
{$R-}                                               { keine Bereichsprfung }
{$S-}                                                  { keine Stackprfung }
{$X+}                    { Behandlung von Funktionen wie Prozeduren mglich }

USES CRT, SBDrv;                            { CRT- und SBDrv-Unit einbinden }

{===========================================================================}
{ Funktion GetBoardName: Liefert den Namen der Soundkarte zu dem angegebe-  }
{                        nen Kartentyp zurck.                              }
{===========================================================================}
{ Eingabe: WhatType = Kartentyp                                             }
{ Ausgabe: Name der Karte                                                   }
{---------------------------------------------------------------------------}

FUNCTION GetBoardName(WhatType : Word) : String;

BEGIN
  CASE WhatType OF
    type_SB_SBMCV :
      GetBoardName := 'Sound Blaster 1.5 oder Sound Blaster MCV';
    type_SBPro :
      GetBoardName := 'Sound Blaster Pro 3, Audio Blaster 2.5 oder AB '+
        'Pro 4';
    type_SB20 :
      GetBoardName := 'Sound Blaster 2.0';
    type_SB16 :
      GetBoardName := 'Sound Blaster 16 ASP oder vergleichbare Karte';
  ELSE
    GetBoardName := 'Soundkartentyp nicht erkannt';
  END;
END;

{---------------------------------------------------------------------------}
{ Hauptprogramm                                                             }
{---------------------------------------------------------------------------}

CONST
  BufSize = 60*1024;                                          { Puffergre }

VAR
  Result    : Integer;                      { speichert Funktionsergebnisse }
  DrvVer    : Byte;                                  { Treiber-Hauptversion }
  DrvSubVer : Byte;                                  { Treiber-Unterversion }

BEGIN
  InitSBDrv;                                    { Unit SBDrv initialisieren }
  TextColor(LightGray);                                { Textfarbe hellgrau }
  ClrScr;                                              { Bildschirm lschen }
  WriteLn('  DATA BECKERs Sound Blaster Superbuch  *  SBINFO  *  (c) '+
    '1993 by Arthur Burda');
  WriteLn(''+
    '');
  WriteLn;
  Result := Load_CTVOICE;                      { Treiber CT-VOICE.DRV laden }
  IF Result <> 0 THEN              { Ist beim Laden ein Fehler aufgetreten? }
    BEGIN                                      { ja, Fehlermeldung ausgeben }
      WriteLn('Fehler beim Laden von CT-VOICE.DRV');
      WriteLn('Fehlercode: ', Result);
    END
  ELSE                                                        { kein Fehler }
    BEGIN                                     { Sound-Blaster-Info anzeigen }

      { Basis-Addresse, Interrupt-Nummer und }
      { DMA-Kanal (nur bei SB Pro) setzen    }

      SetBaseAddress(SB_BaseAddress);
      SetInterrupt(SB_Interrupt);
      IF GetBoardType IN [type_SBPro, type_SB16] THEN
        SetDMAChannel(SB_DMAChannel);

      DriverInit(BufSize SHR 12);                  { Treiber initialisieren }
      GetDriverVer(DrvVer, DrvSubVer);
      WriteLn('Soundkartentyp       : ', GetBoardName(GetBoardType));
      WriteLn('Treiberverzeichnis   : ', SB_DriverPath);
      WriteLn('Basis-I/O-Adresse    : ', ((SB_BaseAddress DIV 16)-12)*10,
        ' hex.');
      WriteLn('Interrupt-Nummer     : ', SB_Interrupt);
      WriteLn('DMA-Kanal            : ', SB_DMAChannel);
      WriteLn('Version von CT-VOICE : ', DrvVer, '.', DrvSubVer);
      DriverEnd;                                          { Treiber beenden }
    END;
  WriteLn;
  WriteLn('Drcken Sie bitte irgendeine Taste ...');
  REPEAT                       { warten, bis irgendeine Taste gedrckt wird }
  UNTIL KeyPressed;
END.
