
;===========================================================================;
; Konzept           : DATA BECKERs Sound Blaster Superbuch                  ;
; Prog. Ports       : Ein Beispiel fr die Programmierung des PC-Lautspre-  ;
;                     chers mit Hilfe der Ports                             ;
;===========================================================================;
; Autor             : Arthur Burda                                          ;
; Dateiname         : PORTS.ASM                                             ;
; entwickelt am     : 20.07.1993                                            ;
; letztes Update    : 01.09.1993                                            ;
; Version           : 1.01                                                  ;
; Compiler          : Turbo Assembler 1.0 und hher bzw. Makro Assembler    ;
;===========================================================================;

.MODEL SMALL
.CODE

Start:         JMP   Main                ; Sprung zum Hauptprogramm

;===========================================================================;
; Wait_: Wartet einige Millisekunden.                                       ;
;===========================================================================;
; Eingabe: keine                                                            ;
; Ausgabe: keine                                                            ;
;---------------------------------------------------------------------------;

Wait_          PROC
               PUSH  AX                  ; AX-Register auf dem Stack sichern
               PUSH  CX
               PUSH  DX
               MOV   AH,86h              ; Nummer der Funktion nach AH
               MOV   CX,2
               MOV   DX,0
               INT   15h                 ; Interrupt 15h (BIOS) auslsen
               POP   DX                  ; DX-Register zurckholen
               POP   CX
               POP   AX
               RET                       ; Rcksprung
Wait_          ENDP

;---------------------------------------------------------------------------;
; Hauptprogramm                                                             ;
;---------------------------------------------------------------------------;

Main:          MOV   CX,1                ; Zhler auf 1 setzen
Repeat:        IN    AL,61h              ; Inhalt des Ports 61h lesen
               OR    AL,3                ; OR-Verknpfung mit dem Wert 3
               OUT   61h,AL              ; Ton einschalten
               CALL  Wait_               ; Verzgerung
               IN    AL,61h              ; Inhalt des Ports 61h lesen
               AND   AL,255-3            ; AND-Verknpfung mit 255-3
               OUT   61h,AL              ; Ton ausschalten
               CALL  Wait_               ; Pause (kein Ton zu hren)
               CMP   CX,10               ; Zhlerstand 10?
               JE    RepeatEnd           ; Ja, Ende der Schleife
               INC   CX                  ; Zhler um 1 erhhen
               JMP   Repeat              ; Schleife fortsetzen
RepeatEnd:     MOV   AH,4Ch              ; Funktion zum Beenden des Programms
               INT   21h                 ; DOS-Interrupt auslsen und das
                                         ; Programm beenden

END
