
/*=========================================================================*/
/* Konzept        : DATA BECKERs Sound Blaster Superbuch                   */
/* Prog. IntrVec  : Ein Beispielprogramm, das zeigt, wie man einen Inter-  */
/*                  rupt-Vektor umleitet (in dem Fall Timer-Interrupt, das */
/*                  hufig in Verbindung mit der Sound-Blaster-Programmie- */
/*                  rung umgeleitet wird).                                 */
/*=========================================================================*/
/* Autor          : Arthur Burda                                           */
/* Dateiname      : INTRVEC.C                                              */
/* entwickelt am  : 20.07.1993                                             */
/* letztes Update : 01.09.1993                                             */
/* Version        : 1.01                                                   */
/* Compiler       : Turbo C, Turbo C++, Borland C++                        */
/*=========================================================================*/

#include <stdio.h>
#include <dos.h>
#include <conio.h>

#define TimerOld 103                              /* alter Timer-Interrupt */

int Count;                                                   /* ein Zhler */

/*=========================================================================*/
/* NewTimerInt: Neuer Timer-Interrupt                                      */
/*=========================================================================*/
/* Eingabe: keine                                                          */
/* Ausgabe: keine                                                          */
/*-------------------------------------------------------------------------*/

void interrupt NewTimerInt()

{
  if (Count == 100)                                    /* Zhlerstand 100? */
    {                                                                /* ja */
      printf("Timer-Handler wird wieder auf Standard-Routine gesetzt.");
      printf("\n");
    }
  else                                                     /* Count <> 100 */
    {
      printf("Benutzerdefinierter Timer-Handler ist installiert.");
      printf("\n");
    }
  Count++;                                          /* Zhler um 1 erhhen */
  outportb(0x20, 0x20);                       /* Interrupt-Routine beenden */
}

/*-------------------------------------------------------------------------*/
/* main: Hauptprogramm                                                     */
/*-------------------------------------------------------------------------*/

void main()

{
  clrscr();                                          /* Bildschirm lschen */
  Count = 0;                                        /* Zhler auf 0 setzen */
  setvect(TimerOld, getvect(0x08));          /* alten Timer-Vektor sichern */
  setvect(0x08, NewTimerInt);                /* neuen Handler installieren */
  while (Count <= 100);                    /* wiederholen, bis Count > 100 */
  setvect(0x08, getvect(TimerOld));           /* alten Timer-Vektor setzen */
};
