
{===========================================================================}
{ Konzept        : DATA BECKERs Sound Blaster Superbuch                     }
{ Prog. FMDemo3  : Ein Demo-Programm fr die direkte Programmierung der FM- }
{                  Kanle.                                                  }
{===========================================================================}
{ Autor          : Arthur Burda                                             }
{ Dateiname      : FMDEMO3.PAS                                              }
{ entwickelt am  : 21.07.1993                                               }
{ letztes Update : 01.09.1993                                               }
{ Version        : 1.02                                                     }
{ Compiler       : Turbo Pascal 6.0 und hher                               }
{===========================================================================}

PROGRAM FMDemo3;

{---------------------------------------------------------------------------}
{ Compiler-Schalter                                                         }
{---------------------------------------------------------------------------}

{$D-}                                        { keine Debugger-Informationen }
{$F-}                                        { FAR-Aufrufe sind nicht ntig }
{$G+}                                                   { 286-Code erzeugen }
{$I-}                                                   { keine I/O-Prfung }
{$R-}                                               { keine Bereichsprfung }
{$S-}                                                  { keine Stackprfung }
{$X+}                    { Behandlung von Funktionen wie Prozeduren mglich }

USES CRT, SBFM;                              { CRT- und SBFM-Unit einbinden }

{===========================================================================}
{ Prozedur SetHiHatParam: Setzt die Parameter fr "Hi Hat".                 }
{                                                                           }
{                         ANMERKUNG: Zu "Hi Hat" gehrt die Operatorzelle   }
{                                    13, also Kanal 7.                      }
{===========================================================================}
{ Eingabe: keine                                                            }
{ Ausgabe: keine                                                            }
{---------------------------------------------------------------------------}

PROCEDURE SetHiHatParam;

BEGIN
  SetAttack(13, Mono, 9);
  SetDecay(13, Mono, 7);
  SetSustain(13, Mono, 5);
  SetRelease(13, Mono, 7);
  SetWaveForm(13, Mono, 2);
  SetChannelFreq(7, Mono, 500);
END;

{===========================================================================}
{ Prozedur SetSnareDrumParam: Setzt die Parameter fr "Snare Drum".         }
{                                                                           }
{                             ANMERKUNG: Zu "Snare Drum" gehrt die Opera-  }
{                                        torzelle 16, also Kanal 7.         }
{===========================================================================}
{ Eingabe: keine                                                            }
{ Ausgabe: keine                                                            }
{---------------------------------------------------------------------------}

PROCEDURE SetSnareDrumParam;

BEGIN
  SetAttack(16, Mono, 13);
  SetDecay(16, Mono, 9);
  SetSustain(16, Mono, 7);
  SetRelease(16, Mono, 8);
  SetWaveForm(16, Mono, 0);
  SetChannelFreq(7, Mono, 500);
END;

{===========================================================================}
{ Prozedur SetBassDrumParam: Setzt die Parameter fr "Bass Drum".           }
{                                                                           }
{                            ANMERKUNG: Zu "Bass Drum" gehren die Opera-   }
{                                       torzellen 12 und 15, also Kanal 6.  }
{===========================================================================}
{ Eingabe: keine                                                            }
{ Ausgabe: keine                                                            }
{---------------------------------------------------------------------------}

PROCEDURE SetBassDrumParam;

BEGIN
  SetAttack(12, Mono, 10);
  SetDecay(12, Mono, 7);
  SetSustain(12, Mono, 5);
  SetRelease(12, Mono, 4);
  SetWaveForm(12, Mono, 1);
  SetMultFactor(15, Mono, 1);
  SetAttack(15, Mono, 10);
  SetDecay(15, Mono, 12);
  SetSustain(15, Mono, 2);
  SetRelease(15, Mono, 3);
  SetWaveForm(15, Mono, 0);
  SetConnection(6, Mono, Serial);
  SetFeedback(6, Mono, 1);
  SetChannelFreq(6, Mono, 800);
  SetOctave(6, Mono, 1);
END;

{===========================================================================}
{ Prozedur PlayHiHat: Schaltet "Hi Hat" fr die angegebene Zeit ein. Danach }
{                     wird das Instrument wieder ausgeschaltet.             }
{===========================================================================}
{ Eingabe: Wait = Wartezeit in Millisekunden, bis das Instrument wieder     }
{                 ausgeschaltet wird                                        }
{ Ausgabe: keine                                                            }
{---------------------------------------------------------------------------}

PROCEDURE PlayHiHat(Wait : Word);

VAR
  RhythmInstruments : TRhythmInstruments;         { rhythmische Instrumente }

BEGIN
  WITH RhythmInstruments DO
    BEGIN
      HiHat := TRUE;                                 { "Hi Hat" einschalten }
      TopCymbal := FALSE;
      TomTom := FALSE;
      SnareDrum := FALSE;
      BassDrum := FALSE;
    END;
  SetRhythmInstruments(RhythmInstruments);
  Delay(Wait);                                                     { warten }
  WITH RhythmInstruments DO
    BEGIN
      HiHat := FALSE;                         { "Hi Hat" wieder ausschalten }
      TopCymbal := FALSE;
      TomTom := FALSE;
      SnareDrum := FALSE;
      BassDrum := FALSE;
    END;
  SetRhythmInstruments(RhythmInstruments);
END;

{===========================================================================}
{ Prozedur PlaySnareDrum: Schaltet "Snare Drum" fr die angegebene Zeit     }
{                         ein. Danach wird das Instrument wieder ausge-     }
{                         schaltet.                                         }
{===========================================================================}
{ Eingabe: Wait = Wartezeit in Millisekunden, bis das Instrument wieder     }
{                 ausgeschaltet wird                                        }
{ Ausgabe: keine                                                            }
{---------------------------------------------------------------------------}

PROCEDURE PlaySnareDrum(Wait : Word);

VAR
  RhythmInstruments : TRhythmInstruments;         { rhythmische Instrumente }

BEGIN
  WITH RhythmInstruments DO
    BEGIN
      HiHat := FALSE;
      TopCymbal := FALSE;
      TomTom := FALSE;
      SnareDrum := TRUE;                         { "Snare Drum" einschalten }
      BassDrum := FALSE;
    END;
  SetRhythmInstruments(RhythmInstruments);
  Delay(Wait);                                                     { warten }
  WITH RhythmInstruments DO
    BEGIN
      HiHat := FALSE;
      TopCymbal := FALSE;
      TomTom := FALSE;
      SnareDrum := FALSE;                 { "Snare Drum" wieder ausschalten }
      BassDrum := FALSE;
    END;
  SetRhythmInstruments(RhythmInstruments);
END;

{===========================================================================}
{ Prozedur PlayBassDrum: Schaltet "Bass Drum" fr die angegebene Zeit ein.  }
{                        Danach wird das Instrument wieder ausgeschaltet.   }
{===========================================================================}
{ Eingabe: Wait = Wartezeit in Millisekunden, bis das Instrument wieder     }
{                 ausgeschaltet wird                                        }
{ Ausgabe: keine                                                            }
{---------------------------------------------------------------------------}

PROCEDURE PlayBassDrum(Wait : Word);

VAR
  RhythmInstruments : TRhythmInstruments;         { rhythmische Instrumente }

BEGIN
  WITH RhythmInstruments DO
    BEGIN
      HiHat := FALSE;
      TopCymbal := FALSE;
      TomTom := FALSE;
      SnareDrum := FALSE;
      BassDrum := TRUE;                           { "Bass Drum" einschalten }
    END;
  SetRhythmInstruments(RhythmInstruments);
  Delay(Wait);                                                     { warten }
  WITH RhythmInstruments DO
    BEGIN
      HiHat := FALSE;
      TopCymbal := FALSE;
      TomTom := FALSE;
      SnareDrum := FALSE;
      BassDrum := FALSE;                   { "Bass Drum" wieder ausschalten }
    END;
  SetRhythmInstruments(RhythmInstruments);
END;

{---------------------------------------------------------------------------}
{ Hauptprogramm                                                             }
{---------------------------------------------------------------------------}

VAR
  Count : Word;                                                { ein Zhler }

BEGIN
  TextColor(LightGray);                                { Textfarbe hellgrau }
  ClrScr;                                              { Bildschirm lschen }
  WriteLn(' DATA BECKERs Sound Blaster Superbuch  *  FMDEMO3  *  (c) '+
    '1993 by Arthur Burda');
  WriteLn(''+
    '');
  WriteLn;
  WriteLn('Dieses Programm demonstriert die Programmierung der Percussion-'+
    'Instrumente im');
  WriteLn('Rhythmus-Modus. Folgende Instrumente werden verwendet: Hi Hat, '+
    'Snare Drum und');
  WriteLn('Bass Drum.');
  SetHiHatParam;                                { "Hi Hat"-Parameter setzen }
  SetSnareDrumParam;                        { "Snare Drum"-Parameter setzen }
  SetBassDrumParam;                          { "Bass Drum"-Parameter setzen }
  SetRhythmusMode(TRUE);                        { Rhythmus-Modus aktivieren }
  FOR Count := 1 TO 2 DO
    PlayHiHat(500);           { "Hi Hat" fr eine halbe Sekunde einschalten }
  FOR Count := 1 TO 4 DO
    PlayHiHat(250);                  { "Hi Hat" fr 1/4 Sekunde einschalten }
  FOR Count := 1 TO 2 DO
    PlaySnareDrum(500);   { "Snare Drum" fr eine halbe Sekunde einschalten }
  FOR Count := 1 TO 4 DO
    PlaySnareDrum(250);          { "Snare Drum" fr 1/4 Sekunde einschalten }
  FOR Count := 1 TO 4 DO
    PlayBassDrum(200);      { "Bass Drum" fr 200 Millisekunden einschalten }
  SetRhythmusMode(FALSE);                     { Rhythmus-Modus deaktivieren }
END.
