
{===========================================================================}
{ Konzept        : DATA BECKERs Sound Blaster Superbuch                     }
{ Prog. FMDemo2  : Ein Demo-Programm fr die direkte Programmierung der FM- }
{                  Kanle.                                                  }
{===========================================================================}
{ Autor          : Arthur Burda                                             }
{ Dateiname      : FMDEMO2.PAS                                              }
{ entwickelt am  : 20.07.1993                                               }
{ letztes Update : 01.09.1993                                               }
{ Version        : 1.01                                                     }
{ Compiler       : Turbo Pascal 6.0 und hher                               }
{===========================================================================}

PROGRAM FMDemo2;

{---------------------------------------------------------------------------}
{ Compiler-Schalter                                                         }
{---------------------------------------------------------------------------}

{$D-}                                        { keine Debugger-Informationen }
{$F-}                                        { FAR-Aufrufe sind nicht ntig }
{$G+}                                                   { 286-Code erzeugen }
{$I-}                                                   { keine I/O-Prfung }
{$R-}                                               { keine Bereichsprfung }
{$S-}                                                  { keine Stackprfung }
{$X+}                    { Behandlung von Funktionen wie Prozeduren mglich }

USES CRT, SBFM;                              { CRT- und SBFM-Unit einbinden }

TYPE

  {=========================================================================}
  { TChannelParam: Parameter der Operatorzellen Modulator und Trger eines  }
  {                FM-Kanals. Ein "m" vor dem Feldnamen bedeutet Modulator- }
  {                zelle, ein "c" Trgerzelle.                              }
  {=========================================================================}

  TChannelParam = RECORD
    mMultFactor   : Byte;                    { Multiplikationsfaktor (0-15) }
    cMultFactor   : Byte;
    mEnvelopeType : TEnvelope;  { Art der Hllkurve (Dimishing, Continuing) }
    cEnvelopeType : TEnvelope;
    mVibrato      : Boolean;                        { Vibrato-Effekt an/aus }
    cVibrato      : Boolean;
    mVibratoLevel : Byte;                            { Vibrato-Strke (0-1) }
    cVibratoLevel : Byte;
    mTremolo      : Boolean;                        { Tremolo-Effekt an/aus }
    cTremolo      : Boolean;
    mTremoloLevel : Byte;                            { Tremolo-Strke (0-1) }
    cTremoloLevel : Byte;
    mAttenuation  : Byte;                          { Dmpfungsfaktor (0-63) }
    cAttenuation  : Byte;
    mAttack       : Byte;                         { Attack-Parameter (0-15) }
    cAttack       : Byte;
    mDecay        : Byte;                               { Decay-Rate (0-15) }
    cDecay        : Byte;
    mSustain      : Byte;                        { Sustain-Parameter (0-15) }
    cSustain      : Byte;
    mRelease      : Byte;                        { Release-Parameter (0-15) }
    cRelease      : Byte;
    mWaveForm     : Byte;                                { Wellenform (0-3) }
    cWaveForm     : Byte;
    Connection    : TCellConnection; { Zellenverknpfung (Parallel, Serial) }
    Feedback      : Byte;                         { Rckkopplungsgrad (0-7) }
    Freq          : Word;                     { Frequenz-Parameter (0-1023) }
    Octave        : Byte;                                    { Oktave (0-7) }
  END;

{===========================================================================}
{ Prozedur SetChannelParam: Setzt die Parameter der beiden Operatorzellen   }
{                           (Modulator und Trger) eines Kanals. Die Para-  }
{                           meter fr die Modulatorzelle knnen sich von    }
{                           denen der Trgerzelle in allen Punkten unter-   }
{                           scheiden.                                       }
{===========================================================================}
{ Eingabe: Channel = Nummer des Kanals (0-8)                                }
{          Param   = Parameter fr die Modulator- und Trgerzelle           }
{ Ausgabe: keine                                                            }
{---------------------------------------------------------------------------}

PROCEDURE SetChannelParam(Channel : Byte; Param : TChannelParam);

VAR
  Modulator : Byte;                             { Modulatorzelle des Kanals }
  Carrier   : Byte;                                { Trgerzelle des Kanals }

BEGIN
  Modulator := sbfm_ModCellNum[Channel];
  Carrier := sbfm_CarrCellNum[Channel];

  WITH Param DO
    BEGIN

      { Multiplikationsfaktor fr Modulator und Trger setzen }

      SetMultFactor(Modulator, Mono, mMultFactor);
      SetMultFactor(Carrier, Mono, cMultFactor);

      { Art der Hllkurve setzen }

      SetEnvelopeType(Modulator, Mono, mEnvelopeType);
      SetEnvelopeType(Carrier, Mono, cEnvelopeType);

      { Vibrato- und Tremolo-Effekt sowie deren Strke setzen }

      SetVibrato(Modulator, Mono, mVibrato, mVibratoLevel);
      SetVibrato(Carrier, Mono, cVibrato, cVibratoLevel);
      SetTremolo(Modulator, Mono, mTremolo, mTremoloLevel);
      SetTremolo(Carrier, Mono, cTremolo, cTremoloLevel);

      { Dmpfungsfaktor setzen }

      SetAttenuation(Modulator, Mono, mAttenuation);
      SetAttenuation(Carrier, Mono, cAttenuation);

      { Attack-Parameter setzen }

      SetAttack(Modulator, Mono, mAttack);
      SetAttack(Carrier, Mono, cAttack);

      { Decay-Parameter setzen }

      SetDecay(Modulator, Mono, mDecay);
      SetDecay(Carrier, Mono, cDecay);

      { Sustain-Parameter setzen }

      SetSustain(Modulator, Mono, mSustain);
      SetSustain(Carrier, Mono, cSustain);

      { Release-Parameter setzen }

      SetRelease(Modulator, Mono, mRelease);
      SetRelease(Carrier, Mono, cRelease);

      { Wellenform des Modulators und des Trgers setzen }

      SetWaveForm(Modulator, Mono, mWaveForm);
      SetWaveForm(Carrier, Mono, cWaveForm);

      SetConnection(Channel, Mono, Connection);    { Zellenverknpfungsart, }
      SetFeedback(Channel, Mono, Feedback);            { Rckkopplungsgrad, }
      SetChannelFreq(Channel, Mono, Freq);                       { Frequenz }
      SetOctave(Channel, Mono, Octave);                 { und Oktave setzen }
    END;
END;

{===========================================================================}
{ Prozedur GetChannelParam0: Setzt die Einstellungen fr einen Ton auf dem  }
{                            Kanal 0 und liefert diese Parameter zurck.    }
{===========================================================================}
{ Eingabe: keine                                                            }
{ Ausgabe: Param = Parameter                                                }
{---------------------------------------------------------------------------}

PROCEDURE GetChannelParam0(VAR Param : TChannelParam);

BEGIN
  WITH Param DO
    BEGIN
      mMultFactor := 1;
      cMultFactor := 2;
      mEnvelopeType := Continuing;
      cEnvelopeType := Continuing;
      mVibrato := TRUE;
      cVibrato := FALSE;
      mVibratoLevel := 1;
      cVibratoLevel := 0;
      mTremolo := TRUE;
      cTremolo := FALSE;
      mTremoloLevel := 0;
      cTremoloLevel := 0;
      mAttenuation := 5;
      cAttenuation := 4;
      mAttack := 3;
      cAttack := 2;
      mDecay := 4;
      cDecay := 3;
      mSustain := 9;
      cSustain := 8;
      mRelease := 8;
      cRelease := 7;
      mWaveForm := 2;
      cWaveForm := 1;
      Connection := Serial;
      Feedback := 5;
      Freq := 100;
      Octave := 3;
    END;
  SetChannelParam(0, Param);       { Parameter in die FM-Register eintragen }
END;

{===========================================================================}
{ Prozedur GetChannelParam1: Setzt die Einstellungen fr einen Ton auf dem  }
{                            Kanal 1 und liefert diese Parameter zurck.    }
{===========================================================================}
{ Eingabe: keine                                                            }
{ Ausgabe: Param = Parameter                                                }
{---------------------------------------------------------------------------}

PROCEDURE GetChannelParam1(VAR Param : TChannelParam);

BEGIN
  WITH Param DO
    BEGIN
      mMultFactor := 1;
      cMultFactor := 1;
      mEnvelopeType := Continuing;
      cEnvelopeType := Continuing;
      mVibrato := TRUE;
      cVibrato := TRUE;
      mVibratoLevel := 1;
      cVibratoLevel := 1;
      mTremolo := TRUE;
      cTremolo := FALSE;
      mTremoloLevel := 1;
      cTremoloLevel := 0;
      mAttenuation := 0;
      cAttenuation := 0;
      mAttack := 10;
      cAttack := 9;
      mDecay := 7;
      cDecay := 6;
      mSustain := 6;
      cSustain := 4;
      mRelease := 4;
      cRelease := 4;
      mWaveForm := 1;
      cWaveForm := 3;
      Connection := Serial;
      Feedback := 3;
      Freq := 500;
      Octave := 2;
    END;
  SetChannelParam(1, Param);
END;

{===========================================================================}
{ Prozedur GetChannelParam2: Setzt die Einstellungen fr einen Ton auf dem  }
{                            Kanal 2 und liefert diese Parameter zurck.    }
{===========================================================================}
{ Eingabe: keine                                                            }
{ Ausgabe: Param = Parameter                                                }
{---------------------------------------------------------------------------}

PROCEDURE GetChannelParam2(VAR Param : TChannelParam);

BEGIN
  WITH Param DO
    BEGIN
      mMultFactor := 1;
      cMultFactor := 1;
      mEnvelopeType := Continuing;
      cEnvelopeType := Continuing;
      mVibrato := TRUE;
      cVibrato := TRUE;
      mVibratoLevel := 0;
      cVibratoLevel := 1;
      mTremolo := FALSE;
      cTremolo := FALSE;
      mTremoloLevel := 0;
      cTremoloLevel := 0;
      mAttenuation := 0;
      cAttenuation := 0;
      mAttack := 8;
      cAttack := 3;
      mDecay := 8;
      cDecay := 2;
      mSustain := 5;
      cSustain := 2;
      mRelease := 4;
      cRelease := 2;
      mWaveForm := 0;
      cWaveForm := 3;
      Connection := Serial;
      Feedback := 2;
      Freq := 500;
      Octave := 2;
    END;
  SetChannelParam(2, Param);
END;

{===========================================================================}
{ Prozedur GetChannelParam3: Setzt die Einstellungen fr einen Ton auf dem  }
{                            Kanal 3 und liefert diese Parameter zurck.    }
{===========================================================================}
{ Eingabe: keine                                                            }
{ Ausgabe: Param = Parameter                                                }
{---------------------------------------------------------------------------}

PROCEDURE GetChannelParam3(VAR Param : TChannelParam);

BEGIN
  WITH Param DO
    BEGIN
      mMultFactor := 1;
      cMultFactor := 1;
      mEnvelopeType := Continuing;
      cEnvelopeType := Continuing;
      mVibrato := FALSE;
      cVibrato := FALSE;
      mVibratoLevel := 0;
      cVibratoLevel := 0;
      mTremolo := FALSE;
      cTremolo := FALSE;
      mTremoloLevel := 0;
      cTremoloLevel := 0;
      mAttenuation := 0;
      cAttenuation := 0;
      mAttack := 10;
      cAttack := 12;
      mDecay := 5;
      cDecay := 6;
      mSustain := 12;
      cSustain := 10;
      mRelease := 12;
      cRelease := 14;
      mWaveForm := 1;
      cWaveForm := 3;
      Connection := Serial;
      Feedback := 5;
      Freq := 500;
      Octave := 1;
    END;
  SetChannelParam(3, Param);
END;

{---------------------------------------------------------------------------}
{ Hauptprogramm                                                             }
{---------------------------------------------------------------------------}

VAR
  Param0, Param1, Param2, Param3 : TChannelParam;  { Parameter fr die Tne }

BEGIN
  TextColor(LightGray);                                { Textfarbe hellgrau }
  ClrScr;                                              { Bildschirm lschen }
  WriteLn(' DATA BECKERs Sound Blaster Superbuch  *  FMDEMO2  *  (c) '+
    '1993 by Arthur Burda');
  WriteLn(''+
    '');
  WriteLn;
  WriteLn('Dieses Programm demonstriert FM-Musik mit 4 Kanlen '+
    '(Instrumenten), die alle');
  WriteLn('gleichzeitig und unabhngig voneinander spielen.');

  { Parameter fr die Tne auf 4 verschiedenen Kanlen }
  { setzen und in Variablen speichern                  }

  GetChannelParam0(Param0);
  GetChannelParam1(Param1);
  GetChannelParam2(Param2);
  GetChannelParam3(Param3);

  { FM-Musik mit 4 Kanlen gleichzeitig }

  SetTone(2, Mono, TRUE);
  Delay(2000);
  SetTone(1, Mono, TRUE);
  Delay(800);
  SetTone(1, Mono, FALSE);
  Param1.cVibrato := FALSE;
  Param1.cVibratoLevel := 0;
  Param1.mAttenuation := 4;
  Param1.cAttenuation := 3;
  Param1.mAttack := 3;
  Param1.cAttack := 2;
  Param1.mDecay := 6;
  Param1.cDecay := 5;
  Param1.mSustain := 12;
  Param1.cSustain := 14;
  Param1.mRelease := 14;
  Param1.mRelease := 13;
  Param1.mWaveForm := 2;
  Param1.cWaveForm := 1;
  Param1.Feedback := 0;
  SetChannelParam(1, Param1);
  SetTone(1, Mono, TRUE);
  Delay(1200);
  SetTone(1, Mono, FALSE);
  SetTone(1, Mono, TRUE);
  Delay(1600);
  SetTone(2, Mono, FALSE);
  SetTone(2, Mono, TRUE);
  Delay(3000);
  SetTone(3, Mono, TRUE);
  Delay(400);
  SetTone(3, Mono, FALSE);
  Param3.mAttenuation := 5;
  Param3.cAttenuation := 6;
  SetChannelParam(3, Param3);
  SetTone(3, Mono, TRUE);
  Delay(400);
  SetTone(3, Mono, FALSE);
  Param3.mAttenuation := 12;
  Param3.cAttenuation := 13;
  SetChannelParam(3, Param3);
  SetTone(3, Mono, TRUE);
  Delay(200);
  SetTone(0, Mono, TRUE);
END.
