
;===========================================================================;
; Konzept           : DATA BECKERs Sound Blaster Superbuch                  ;
; Programm DSP_DEMO : Ein Assemblerbeispiel fr direkte DSP-Programmierung  ;
;===========================================================================;
; Autor             : Arthur Burda                                          ;
; Dateiname         : DSP_DEMO.ASM                                          ;
; entwickelt am     : 21.07.1993                                            ;
; letztes Update    : 30.07.1993                                            ;
; Version           : 1.02                                                  ;
; Compiler          : Turbo Assembler 1.0 und hher bzw. Makro Assembler    ;
;===========================================================================;

TITLE DSP_DEMO

ASSUME CS:CODE_SEG,DS:DATA_SEG         ; Informationen ber Segmente

;---------------------------------------------------------------------------;
; Code-Segment                                                              ;
;---------------------------------------------------------------------------;

CODE_SEG       SEGMENT

               JMP   Main              ; Sprung zum Hauptprogramm

;===========================================================================;
; ClrScr: Lscht den Bildschirm mit Hilfe der BIOS-Funktion 06h (Textzeilen ;
;         nach oben schieben).                                              ;
;===========================================================================;
; Eingabe: keine                                                            ;
; Ausgabe: keine                                                            ;
;---------------------------------------------------------------------------;

ClrScr         PROC
               PUSH  AX                  ; AX-Register auf dem Stack sichern
               PUSH  BX
               PUSH  CX
               PUSH  DX
               MOV   AH,06h              ; Nummer der Funktion in AH-Register
                                         ; laden
               MOV   AL,00h              ; 0 Textzeilen nach oben verschieben
                                         ; bedeutet Lschen des Bildschirms
               MOV   CH,00h              ; Zeile der oberen linken Bild-
                                         ; schirmecke
               MOV   CL,00h              ; Spalte der oberen linken Bild-
                                         ; schirmecke
               MOV   DH,18h              ; Zeile der unteren rechten Bild-
                                         ; schirmecke
               MOV   DL,4Fh              ; Spalte der unteren rechten Bild-
                                         ; schirmecke
               MOV   BH,07h              ; Textattribut hellgrau auf schwarz
               INT   10h                 ; BIOS-Interrupt auslsen
               POP   DX                  ; DX-Register restaurieren
               POP   CX
               POP   BX
               POP   AX
               RET                       ; Rcksprung
ClrScr         ENDP

;===========================================================================;
; CursorUp: Positioniert den Cursor in der oberen linken Bildschirmecke.    ;
;===========================================================================;
; Eingabe: keine                                                            ;
; Ausgabe: keine                                                            ;
;---------------------------------------------------------------------------;

CursorUp       PROC
               PUSH  AX                  ; AX-Register auf dem Stack sichern
               PUSH  BX
               PUSH  DX
               MOV   AH,02h              ; Nummer der Funktion in AH-Register
                                         ; laden
               MOV   BH,00h              ; Bildschirmseite 0
               MOV   DH,00h              ; Bildschirmzeile 0
               MOV   DL,00h              ; Bildschirmspalte 0
               INT   10h                 ; String-Ausgabe via BIOS
               POP   DX                  ; DX-Register vom Stack holen
               POP   BX
               POP   AX
               RET                       ; Rcksprung
CursorUp       ENDP

;===========================================================================;
; OutMessages: Zeigt Meldungen (Programmname u.a.) auf dem Bildschirm an.   ;
;===========================================================================;
; Eingabe: keine                                                            ;
; Ausgabe: keine                                                            ;
;---------------------------------------------------------------------------;

OutMessages    PROC
               PUSH  AX                  ; AX-Register auf dem Stack sichern
               PUSH  DX
               MOV   AH,09h              ; Nummer der Funktion nach AH-Reg.
               MOV   DX,OFFSET ProgName  ; Offset von ProgName bestimmen
               INT   21h                 ; DOS-Interrupt auslsen
               MOV   DX,OFFSET Line      ; Offset von Line in DX-Reg. laden
               INT   21h                 ; Interrupt-Aufruf
               POP   DX                  ; DX-Register vom Stack holen
               POP   AX
               RET                       ; Rcksprung
OutMessages    ENDP

;===========================================================================;
; Wait_: bergibt die Kontrolle erst dann wieder an den Aufrufer, wenn eine ;
;        bestimmte Zeit verstrichen ist.                                    ;
;===========================================================================;
; Eingabe: CX = Hi-Word der Pause in Mikrosekunden                          ;
;          DX = Lo-Word der Pause in Mikrosekunden                          ;
; Ausgabe: keine                                                            ;
;---------------------------------------------------------------------------;

Wait_          PROC
               PUSH  AX                  ; AX-Register auf dem Stack sichern
               MOV   AH,86h              ; Nummer der Funktion nach AH
               INT   15h                 ; Interrupt 15h (BIOS) auslsen
               POP   AX                  ; AX-Register zurckholen
               RET                       ; Rcksprung
Wait_          ENDP

;===========================================================================;
; WriteDSP: Sendet einen Bytewert an den Soundprozessor. Ist dieser mit     ;
;           seiner letzten Aktion beschftigt, mu beim Senden des Bytewer- ;
;           tes gewartet werden, bis diese Aktion ordungsgem beendet ist. ;
;===========================================================================;
; Eingabe: BH = Bytewert                                                    ;
; Ausgabe: keine                                                            ;
;---------------------------------------------------------------------------;

WriteDSP       PROC
               PUSH  AX                  ; AX-Register auf dem Stack sichern
               PUSH  CX
               PUSH  DX
               MOV   CX,0                ; Zhler in CX laden und auf Null
                                         ; setzen
               MOV   DX,BaseAddr         ; Basis-I/O-Adresse nach DX
               ADD   DX,0Ch              ; Register 12 ist fr direkte
                                         ; VOICE-Ausgabe zustndig
Check:         IN    AL,DX               ; Inhalt in AL speichern
               AND   AL,80h              ; AND-Verknpfung mit dem Wert 128
               CMP   AL,00h              ; DSP empfangsbereit?
               JE    Write               ; Ja, Sprung zur Marke Write
               CMP   CX,10000            ; Nein. Hat der Zhler den Stand
                                         ; 10000 erreicht?
               JE    Error               ; Ja, Fehler
               INC   CX                  ; Nein, Zhler um 1 erhhen
               JMP   Check               ; Schleife fortsetzen
Write:         MOV   AL,BH               ; Bytewert in AL-Register laden
               OUT   DX,AL               ; und zum DSP senden
               JMP   End_                ; Sprung zur Marke End_
Error:         MOV   AH,09h              ; Nummer der Funktion nach AH-Reg.
               MOV   DX,OFFSET DSPError  ; Offset von DSPError bestimmen
               INT   21h                 ; DOS-Interrupt auslsen, um die
                                         ; Fehlermeldung auszugeben
	       MOV   AH,4Ch              ; Funktion zum Beenden des Programms
               INT   21h                 ; Programm wegen Fehler beenden
End_:          POP   DX                  ; DX-Register vom Stack holen
               POP   CX
               POP   AX
               RET                       ; Rcksprung
WriteDSP       ENDP

;===========================================================================;
; WriteDirect: Veranlat den DSP zur Ausgabe von ungepackten Sounddaten im  ;
;              Direktmodus.                                                 ;
;===========================================================================;
; Eingabe: BH = Bytewert                                                    ;
; Ausgabe: keine                                                            ;
;---------------------------------------------------------------------------;

WriteDirect    PROC
               PUSH  BX                  ; BX-Register eine kurze Weile auf
                                         ; dem Stack sichern
               MOV   BH,dsp_WrtDirect    ; direkte VOICE-Ausgabe
               CALL  WriteDSP            ; zum DSP senden
               POP   BX                  ; BX vom Stack holen
               CALL  WriteDSP            ; und den DSP noch einmal beschrei-
                                         ; ben
               RET                       ; Rcksprung
WriteDirect    ENDP

;===========================================================================;
; Speaker_On: Schaltet den Lautsprecher an.                                 ;
;===========================================================================;
; Eingabe: keine                                                            ;
; Ausgabe: keine                                                            ;
;---------------------------------------------------------------------------;

Speaker_On     PROC
               MOV   BH,dsp_SpeakerOn    ; Nummer der Funktion in BH-Reg.
                                         ; laden
               CALL  WriteDSP            ; DSP direkt ansprechen
               RET                       ; Rcksprung
Speaker_On     ENDP

;===========================================================================;
; Speaker_Off: Schaltet den Lautsprecher aus.                               ;
;===========================================================================;
; Eingabe: keine                                                            ;
; Ausgabe: keine                                                            ;
;---------------------------------------------------------------------------;

Speaker_Off    PROC
               MOV   BH,dsp_SpeakerOff   ; Nummer der Funktion nach BH
               CALL  WriteDSP            ; direkter Zugriff auf DSP
               RET                       ; Rcksprung
Speaker_Off    ENDP

;===========================================================================;
; InitDSP: Initialisiert den DSP.                                           ;
;===========================================================================;
; Eingabe: keine                                                            ;
; Ausgabe: keine                                                            ;
;---------------------------------------------------------------------------;

InitDSP        PROC
               PUSH  AX                  ; AX-Register auf dem Stack sichern
               PUSH  CX
               PUSH  DX
               MOV   DX,BaseAddr         ; Basis-I/O-Adresse nach DX
               ADD   DX,06h              ; Register 6 ansprechen
               MOV   AL,01h
               OUT   DX,AL               ; AL zum DSP senden
               PUSH  DX                  ; DX-Inhalt sichern
               MOV   CX,04h              ; 4 * 256 = 1024 Mikrosek. warten
               MOV   DX,00h
               CALL  Wait_               ; Warte-Routine aufrufen
               POP   DX                  ; DX-Register restaurieren
               MOV   AL,00h
               OUT   DX,AL               ; Inhalt von AL zum DSP senden
               MOV   CX,04h
               MOV   DX,00h            
               CALL  Wait_ 
               POP   DX                  ; AX-Register restaurieren
               POP   CX
               POP   AX
               RET                       ; Rcksprung
InitDSP        ENDP

;---------------------------------------------------------------------------;
; Hauptprogramm                                                             ;
;---------------------------------------------------------------------------;

Main:          MOV   AX,DATA_SEG         ; Daten-Seg.-Adresse in AX-Register
               MOV   DS,AX               ; und anschlieend in DS-Reg. laden
               CALL  ClrScr              ; Bildschirm lschen
               CALL  CursorUp            ; Cursor in die obere linke Ecke
                                         ; des Bildschirms setzen
               CALL  OutMessages         ; Meldungen ausgeben
               CALL  InitDSP             ; DSP initialisieren
               CALL  Speaker_On          ; Lautsprecher ein
               MOV   AH,09h
               MOV   DX,OFFSET Message1
               INT   21h                 ; Meldung via DOS-Interrupt ausgeben
               MOV   AH,09h
               MOV   DX,OFFSET Message2
               INT   21h
               MOV   AX,0                ; Zhler 1 auf Null setzen
Repeat1:       MOV   CX,0                ; Zhler 2 auf Null setzen
Repeat2:       MOV   BH,10h
               CALL  WriteDirect         ; Gerusch erzeugen
               MOV   BH,0FFh
               CALL  WriteDirect
               CMP   CX,100              ; Hat der Zhler 2 den Stand 100
                                         ; erreicht?
               JE    RepeatEnd2          ; Ja, Gerusch beenden
               INC   CX                  ; Nein, Zhler 2 inkrementieren
               JMP   Repeat2             ; innere Schleife fortsetzen
RepeatEnd2:    CMP   AX,100              ; Hat der Zhler 1 den Stand 100
                                         ; erreicht?
               JE    RepeatEnd1          ; Ja
               INC   AX                  ; Zhler 1 inkrementieren
               JMP   Repeat1             ; uere Schleife fortsetzen
RepeatEnd1:    CALL  Speaker_Off         ; Lautsprecher aus
               MOV   AH,09h
               MOV   DX,OFFSET Message3
               INT   21h
               MOV   AH,4Ch              ; Funktion zum Beenden des Programms
               INT   21h                 ; DOS-Interrupt auslsen und das
                                         ; Programm beenden

CODE_SEG       ENDS

;---------------------------------------------------------------------------;
; Daten-Segment                                                             ;
;---------------------------------------------------------------------------;

DATA_SEG       SEGMENT

ProgName       DB ' DATA BECKERs Sound Blaster Superbuch  *  DSP_DEMO  *  '
               DB '(c) 1993 by Arthur Burda',10,13,'$'
Line           DB ''
               DB '',10,13,'$'
Message1       DB 'Der Lautsprecher ist eingeschaltet.',10,13,'$'
Message2       DB 'Das Gerusch mte jetzt zu hren sein.',10,13,'$'
Message3       DB 'Der Lautsprecher wurde wieder ausgeschaltet.',10,13,'$'
DSPError       DB 'Fehler: DSP kann nicht beschrieben werden.',10,13,'$'

BaseAddr       EQU 220h                  ; Standard Basis-I/O-Adresse
dsp_WrtDirect  EQU 10h                   ; direkte Ausgabe von VOICE-Daten
dsp_SpeakerOn  EQU 0D1h                  ; Einschalten des Lautsprechers
dsp_SpeakerOff EQU 0D3h                  ; Ausschalten des Lautsprechers

DATA_SEG       ENDS

               END
