
{===========================================================================}
{ Konzept        : DATA BECKERs Sound Blaster Superbuch                     }
{ Unit DSPMIDI   : Enthlt Routinen zur MIDI-Programmierung ber den DSP.   }
{===========================================================================}
{ Autor          : Arthur Burda                                             }
{ Dateiname      : DSPMIDI.PAS                                              }
{ entwickelt am  : 20.08.1993                                               }
{ letztes Update : 01.09.1993                                               }
{ Version        : 1.01                                                     }
{ Compiler       : Turbo Pascal 6.0 und hher                               }
{===========================================================================}

UNIT DSPMIDI;

{---------------------------------------------------------------------------}
{ Compiler-Schalter                                                         }
{---------------------------------------------------------------------------}

{$B-}                         { Kurzschluverfahren fr boolesche Ausdrcke }
{$D-}                                        { keine Debugger-Informationen }
{$F+}                                                { FAR-Aufrufe erlauben }
{$G+}                                                   { 286-Code erzeugen }
{$I-}                                                   { keine I/O-Prfung }
{$O+}                                            { Unit overlayfhig machen }
{$R-}                                               { keine Bereichsprfung }
{$S-}                                                  { keine Stackprfung }
{$X+}                    { Behandlung von Funktionen wie Prozeduren mglich }

INTERFACE

USES SBDrv, SBDSP;                        { Units SBDrv und SBDSP einbinden }

CONST

  {-------------------------------------------------------------------------}
  { DSP-Kommandos zur MIDI-Programmierung                                   }
  {-------------------------------------------------------------------------}

  { Lesen von MIDI-Daten im direkten (Polling-)Modus }

  dsp_MIDIReadPolling = $30;

  { Lesen von MIDI-Daten im Interrupt-Modus }

  dsp_MIDIReadIntr = $31;

  { MIDI-UART-Modus (direkter Modus) }

  dsp_MIDIUARTPolling = $34;

  { MIDI-UART-Modus (Interrupt-Modus) }

  dsp_MIDIUARTIntr = $35;

  { Schreiben von MIDI-Daten im direkten Modus }

  dsp_MIDIWrite = $38;

{===========================================================================}
{ Funktion DSPMIDIReadPolling: Liest einen MIDI-Wert mittels DSP im direk-  }
{                              ten (Polling-)Modus                          }
{===========================================================================}
{ Eingabe: keine                                                            }
{ Ausgabe: ein Bytewert                                                     }
{---------------------------------------------------------------------------}

FUNCTION DSPMIDIReadPolling : Byte;

{===========================================================================}
{ Funktion DSPMIDIReadIntr: Liest einen MIDI-Wert mittels DSP im Interrupt- }
{                           Modus                                           }
{===========================================================================}
{ Eingabe: keine                                                            }
{ Ausgabe: ein Bytewert                                                     }
{---------------------------------------------------------------------------}

FUNCTION DSPMIDIReadIntr : Byte;

{===========================================================================}
{ Prozedur DSPMIDIWrite: Schreibt einen MIDI-Wert mittels DSP im direkten   }
{                        Modus.                                             }
{===========================================================================}
{ Eingabe: Value = MIDI-Wert                                                }
{ Ausgabe: keine                                                            }
{---------------------------------------------------------------------------}

PROCEDURE DSPMIDIWrite(Value : Byte);

IMPLEMENTATION

FUNCTION DSPMIDIReadPolling : Byte;

BEGIN
  WriteDSP(dsp_MIDIReadPolling);                  { Kommando zum DSP senden }
  DSPMIDIReadPolling := ReadDSP;                                { DSP lesen }
END;

FUNCTION DSPMIDIReadIntr : Byte;

BEGIN
  WriteDSP(dsp_MIDIReadIntr);
  DSPMIDIReadIntr := ReadDSP;
END;

PROCEDURE DSPMIDIWrite(Value : Byte);

BEGIN
  WriteDSP(dsp_MIDIWrite);                        { Kommando zum DSP senden }
  WriteDSP(Value);                                        { DSP beschreiben }
END;

{---------------------------------------------------------------------------}
{ Startcode der Unit                                                        }
{---------------------------------------------------------------------------}

BEGIN
  InitSBDrv;
END.
