/* ------------------------------------------------------------------------ */
/*                                                                          */
/*   TITLE       : DEMOWDP1.C (MSC Version)                                 */
/*                                                                          */
/*   DESCRIPTION :                                                          */
/*       This program demonstrates how to perform wave out using the        */
/*       SGWAVE.LIB library. The wave out is using the disk buffering       */
/*       method.                                                            */
/*                                                                          */
/* ------------------------------------------------------------------------ */

#include <dos.h>
#include <bios.h>
#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <conio.h>

//#include "galaxy.h"
#include "sgsdk.h"
#include "sgc.h"

/* Function prototypes */
void PlayWaveInBkgnd(void);

/* ------------------------------------------------------------------------ */
/*  USAGE:                                                                  */
/*                                                                          */
/*   OutputFile (char *szFilename)                                          */
/*                                                                          */
/*   DESCRIPTION:                                                           */
/*       Output wave with the filename specified.                           */
/*                                                                          */
/*   ENTRY:                                                                 */
/*       szFilename :- filename to be output.                               */
/*                                                                          */
/*   EXIT:                                                                  */
/*       None.                                                              */
/*                                                                          */
/* ------------------------------------------------------------------------ */

void OutputFile(char *szFilename)
{
    int     Handle;

    // Sub Menu
    printf("\nUse the following commands during playback:\n");
    printf("\nS: Stop output");
    printf("\nP: Pause output");
    printf("\nC: Resume output");
    //printf("\nQ: Quit play");
    printf("\n\nPress any key to play...\n\n");
    getch();

    /* Open and play the wave file */
    if ( !_dos_open(szFilename, O_RDONLY, &Handle) )
    {
	/* turn on speaker */
	sgDSPwd_speaker(1);

	if (sgDSPwd_output(Handle) == NO_ERROR)
	{
	    PlayWaveInBkgnd();

	    //if (ctvd_drv_error())
	    //    ShowError();
	    //else
		printf("Wave output ended.\n");
	}
	//else
	//    ShowError();

	_dos_close(Handle);
    }
    else
	printf ( "Open %s file error.\n", szFilename);
}

/* ------------------------------------------------------------------------ */
/*  USAGE:                                                                  */
/*                                                                          */
/*   PlayWaveInBkgnd (void)                                                 */
/*                                                                          */
/*   DESCRIPTION:                                                           */
/*       Control wave playing at the background using keyboard.             */
/*                                                                          */
/*   ENTRY:                                                                 */
/*       None.                                                              */
/*                                                                          */
/*   EXIT:                                                                  */
/*       None.                                                              */
/*                                                                          */
/* ------------------------------------------------------------------------ */

#pragma optimize("l", off)   /* turn off loop optimiaztion */
void PlayWaveInBkgnd(void)
{
    unsigned wKey;

    /* Polls for hot key while playing wave file */

    while (sg_voice_status)
    {
	if ( _bios_keybrd ( _KEYBRD_READY ) )
	{
	    switch ( (wKey = _bios_keybrd(_KEYBRD_READ) & 0xff) )
	    {
		case 0x1b:
		case 's':
		case 'S':
		    sgDSPwd_stop();
		    printf("Wave playing stopped.\n");
		    break;

		case 'p':
		case 'P':
		    sgDSPwd_pause();
		    break;

		case 'c':
		case 'C':
		    sgDSPwd_continue();
		    break;
/***
		case 0x0d:
		    sgDSPwd_break_loop(1);
		    printf("Break-out takes place immediately\n");
		    break;

		case 0x9:
		    sgDSPwd_break_loop(0);
		    printf("Break-out takes place after the current"
			   " loop finishes\n");
		    break;

		case 'q':
		case 'Q':
		    exit(0);
		    break;
***/
	    }
	}
    }
}
#pragma optimize("l", on)


/* ------------------------------------------------------------------------ */
/*  USAGE:                                                                  */
/*                                                                          */
/*   ShowError (void)                                                       */
/*                                                                          */
/*   DESCRIPTION:                                                           */
/*       Display error occurred during the process of wave I/O.             */
/*                                                                          */
/*   ENTRY:                                                                 */
/*       None.                                                              */
/*                                                                          */
/*   EXIT:                                                                  */
/*       None.                                                              */
/*                                                                          */
/* ------------------------------------------------------------------------ */

void ShowError(void)
{
    //int     Err ;

    /* Show the driver error and the DOS extended error code */
    //Err = ctvd_drv_error() ;

    //printf("Driver error = %2d\n", Err) ;

    //Err = ctvd_ext_error();
    //if ( Err != 0 )
    //    printf ("DOS error = %2d\n", Err) ;
}

/*** Main routine ***/
main()
{
    unsigned version_number;
    int      iDSPPort=0x220, iIRQ=7, iDMA=1;
    BYTE data;


    /* Display SG SDK version number */
    version_number = sgGetWavLibVersion();
    printf("Sound Galaxy Developer Kit, ");
    printf("SGWAVE Library Version ");
    printf("%d.%02d\n\n", (version_number>>8) & 0xff, version_number & 0xff);

    /* set to Sound Blaster mode */
    if (!sgSetMode(SB8MODE))
	printf("Set to Sound Blaster compatible mode.\n");

    /***
       Insert BLASTER environment and CARD detection here if desired;
       otherwise, use the configuration program for Sound Galaxy cards
       to set to the desired settings

       Set global variables to the desired IO address, IRQ and DMA channel
       Remember to use the supplied configuration program to configure
       your sound card
    ***/
    printf("Please wait...acquiring card settings...\n");

    iDSPPort = TestBaseAddr();
    if (iDSPPort<0x220 || iDSPPort>0x240)
    {
	printf("Wrong base I/O address setting: %d\n", iDSPPort);
	printf("Please use configuration utility.\n");
	exit(1);
    }
    sgSetBaseAddress(iDSPPort);

    iIRQ = sg_scan_int();
    if (iIRQ<=0)
    {
	printf("Wrong IRQ setting: %d\n", iIRQ);
	printf("Please use configuration utility.\n");
	exit(1);
    }
    sgSetIRQ(iIRQ);

    iDMA = sg_test_dma();
    if (iDMA<0)
    {
	iDMA = 1;
    }
    sgSetDMA(iDMA);

    printf("DSP Port Address = 0x%x\n", iDSPPort);
    printf("IRQ              = %d\n", iIRQ);
    printf("DMA Channel      = %d\n", iDMA);

    outp(0x224,0xe8);
    data = inp(0x225);
    data |= 0x10;
    outp(0x224,0xe8);
    outp(0x225,data);

    sgDSPAux_SetVolume(MASTERVOL,12,12);
    sgDSPAux_SetVolume(VOICEVOL,12,12);
    
    if (!sgDSPwd_init())
	{
	sgDSPwd_speaker(0);

	OutputFile("DEMO.WAV");

	sgDSPwd_terminate();
    }
	else
	printf ("Error on library initialization.\n");

    return(0);
}

